/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.6
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vB_YUI_Upload
// #############################################################################

function vB_YUI_Upload(auth_type, asset_enable, target, postvars, fieldname, uploadform)
{
	this.uploader = null;

	if (YAHOO.util.Dom.get("yui_selectfiles") && auth_type == 0 && asset_enable > 0)
	{
		this.phrases = null;
		this.extensions = null;
		this.max_file_size = 0;
		this.attachlimit = 0;
		this.initactive = (asset_enable == 1);
		this.uploadform = uploadform;
		this.filelist = null;
		this.errors = 0;
		this.success = false;
		this.active = false;
		this.progress = {};
		this.totalsize = 0;
		this.target = target;
		this.postvars = postvars;
		this.fieldname = fieldname;
		this.valid = false;
		this.events = {
				updatetotal             : new YAHOO.util.CustomEvent("updatetotal", this),
				upload                  : new YAHOO.util.CustomEvent("upload", this),
				handleresponse          : new YAHOO.util.CustomEvent("handlereponse", this),
				handleresponse_noerrors : new YAHOO.util.CustomEvent("handleresponse_noerrors", this),
				handleresponse_errors   : new YAHOO.util.CustomEvent("handleresponse_errors", this),
				select                  : new YAHOO.util.CustomEvent("select", this),
				clear                   : new YAHOO.util.CustomEvent("clear", this),
				ready                   : new YAHOO.util.CustomEvent("ready", this),
				uploaddone              : new YAHOO.util.CustomEvent("uploaddone", this)
		};

		YAHOO.widget.Uploader.SWFURL = "clientscript/yui/uploader/assets/uploader.swf";
		try
		{
			this.uploader = new YAHOO.widget.Uploader("yui_selectfiles");

			this.uploader.subscribe("contentReady", this.ready, this, true);
			this.uploader.subscribe("fileSelect", this.select, this, true);
			this.uploader.subscribe("uploadProgress", this.uploadprogress, this, true);
			this.uploader.subscribe("uploadComplete", this.complete, this, true);
			this.uploader.subscribe("uploadCompleteData", this.handleresponse, this, true);
			this.uploader.subscribe("uploadError", this.error, this, true);
			YAHOO.util.Event.on("yui_uploadfiles", "click", this.upload, this, true);
			YAHOO.util.Event.on("yui_clearlist", "click", this.clear, this, true);
			YAHOO.util.Event.on("uploadprogress_ul", "click", this.cancel, this, true);
			YAHOO.util.Event.on("yui_selectfiles", "mouseover", this.handleselectbutton, this, true);
			YAHOO.util.Event.on("yui_selectfiles", "mouseout", this.handleselectbutton, this, true);
		}
		catch(e)
		{}
	}
}

vB_YUI_Upload.prototype.handleselectbutton = function(e)
{
	if (YAHOO.util.Dom.hasClass("yui_selectfilestext", "yui_selectfiles_hover"))
	{
		YAHOO.util.Dom.removeClass("yui_selectfilestext", "yui_selectfiles_hover");
	}
	else
	{
		YAHOO.util.Dom.addClass("yui_selectfilestext", "yui_selectfiles_hover");
	}
}

vB_YUI_Upload.prototype.moveflashobj = function()
{
	// move flash holder to where it needs to be!
	var region = YAHOO.util.Dom.getRegion("yui_selectfilestext");
	if (region)
	{
		YAHOO.util.Dom.setStyle("yui_selectfiles", "width", region.width - 2 + "px");
		YAHOO.util.Dom.setStyle("yui_selectfiles", "height", region.height - 2 + "px");
		var xy = YAHOO.util.Dom.getXY("yui_selectfilestext");
		YAHOO.util.Dom.setXY("yui_selectfiles", xy);
	}
	if (is_moz)
	{	// Don't even ask!
		YAHOO.util.Dom.setStyle("yui_selectfiles", "overflow-x", "");
		YAHOO.util.Dom.setStyle("yui_selectfiles", "overflow-y", "");
		YAHOO.util.Dom.setStyle("yui_selectfiles", "overflow", "");
		YAHOO.util.Dom.setStyle("yui_selectfiles", "overflow", "auto");
	}
}

vB_YUI_Upload.prototype.uploadprogress = function(e)
{
	var li = YAHOO.util.Dom.get(e.id);
	var percent = Math.floor(100 - ((e.bytesLoaded / e.bytesTotal) * 100)) / 100;
	YAHOO.util.Dom.setStyle(li, "backgroundPosition", (-1 * (400 * percent)) + "px 0");

	this.progress[e.id] = e.bytesLoaded;
	var total = 0;
	for (i in this.progress)
	{
		total += this.progress[i];
	}

	var percent = Math.floor((total / this.totalsize) * 100);
	YAHOO.util.Dom.setStyle("yui_progressbar", "width", percent + "%");
}

vB_YUI_Upload.prototype.updatetotal = function()
{
	var count = 0;
	var size = 0;
	for (i in this.filelist)
	{
		count++;
		size += this.filelist[i].size;
	}
	if (count == 0)
	{
		this.filelist = null;
		this.events.updatetotal.fire();
	}
	YAHOO.util.Dom.get("yui_totalfiles").innerHTML = count;
	YAHOO.util.Dom.get("yui_totalsize").innerHTML = format_filesize(size);
}

vB_YUI_Upload.prototype.cancel = function(e)
{
	YAHOO.util.Event.stopEvent(e);
	var target = YAHOO.util.Event.getTarget(e);
	if (target.nodeName.toUpperCase() == "BUTTON")
	{
		var element = null;
		if (element = YAHOO.util.Dom.getAncestorBy(target, function(element)
		{
			if (element.nodeName.toUpperCase() == "LI") {return element;}return false; })
		)
		{
			var progressli = YAHOO.util.Dom.get(element.id);
			if (progressli)
			{
				try
				{
					this.uploader.cancel(element.id);
					this.uploader.removeFile(element.id);
					delete(this.filelist[element.id]);
					var filesleft = 0;
					for (i in this.filelist)
					{
						filesleft++;
					}
					if (!filesleft)
					{
						this.clear(e);
					}
				}
				catch(e)
				{}
				progressli.parentNode.removeChild(progressli);
				this.updatetotal();
			}
		}
	}
}

vB_YUI_Upload.prototype.error = function(e)
{
	e.data = "error: " + e.status;
	this.handleresponse(e);
}

vB_YUI_Upload.prototype.complete = function(e) {}

vB_YUI_Upload.prototype.upload = function(e)
{
	if (this.filelist != null)
	{
		YAHOO.util.Dom.setStyle("yui_basicupload", "display", "none");
		var numfiles = 0;
		this.totalsize = 0;
		this.progress = {};
		for (i in this.filelist)
		{
			this.totalsize += this.filelist[i].size;
			numfiles++;
			this.progress[i] = 0;
		}

		this.uploader.setSimUploadLimit(1);

		var elements = YAHOO.util.Dom.get(this.uploadform).getElementsByTagName("input");
		if (elements.length)
		{
			for (i in elements)
			{
				if (elements[i].type == "hidden")
				{
					var match = elements[i].name.match(/^values\[([^\]]+)\]$/);
					if (match)
					{
						this.postvars[match[0]] = elements[i].value;
					}
				}
			}
		}

		var uploadli = YAHOO.util.Dom.get("uploadprogress_ul");
		var buttons = uploadli.getElementsByTagName("button");
		if (buttons.length)
		{
			for (var x = 1; x < buttons.length; x++)
			{
				YAHOO.util.Dom.addClass(buttons[x], "hidden");
			}
		}

		// Replace this event with a callback
		this.events.upload.fire();

		YAHOO.util.Dom.addClass("yui_clearlist", "hidden");
		YAHOO.util.Dom.removeClass("yui_clearlist", "displayinline");
		YAHOO.util.Dom.addClass("yui_uploadfiles", "hidden");
		YAHOO.util.Dom.removeClass("yui_uploadfiles", "displayinline");
		YAHOO.util.Dom.addClass("yui_selectfilestext", "hidden");
		YAHOO.util.Dom.removeClass("yui_selectfilestext", "displayinline");

		YAHOO.util.Dom.setStyle("yui_progressbar", "width", 0);
		YAHOO.util.Dom.removeClass("yui_progressbar_container", "hidden");

		this.uploader.uploadAll(
			this.target,
			"POST",
			this.postvars,
			this.fieldname
		);
	}
}

vB_YUI_Upload.prototype.displayerror = function(id, error)
{
	var li = YAHOO.util.Dom.get(id);
	YAHOO.util.Dom.setStyle(li, "backgroundPosition", "-400px 0");
	var exclamation = YAHOO.util.Dom.getElementsByClassName("exclamationimg", "img", li);
	var accept = YAHOO.util.Dom.getElementsByClassName("acceptimg", "img", li);
	YAHOO.util.Dom.removeClass(exclamation[0], "hidden");
	YAHOO.util.Dom.addClass(accept[0], "hidden");
	YAHOO.util.Dom.setAttribute(exclamation[0], "title", exclamation[0].title + " " + error);
}

vB_YUI_Upload.prototype.handleresponse = function(e)
{
	//alert(e.id + "\r\n" + e.type + "\r\n" + e.data);

	var li = YAHOO.util.Dom.get(e.id);
	var attachmatch = e.data.match(/^ok - ([\d]+) - ([01])/);
	if (attachmatch)
	{
		var accept = YAHOO.util.Dom.getElementsByClassName("acceptimg", "img", li);
		YAHOO.util.Dom.removeClass(accept[0], "hidden");
		this.success = true;
		this.events.uploaddone.fire(attachmatch[1], attachmatch[2]);
	}
	else
	{
		this.errors++;
		var match = e.data.match(/^error: (.*)$/);
		this.displayerror(e.id, match ? match[1] : this.phrases["upload_failed"]);
	}

	this.progress[e.id] = this.filelist[e.id].size;
	delete(this.filelist[e.id]);
	this.uploader.removeFile(e.id);
	this.updatetotal();

	if (this.filelist == null)
	{
		// store success because calling this.clear(e) will always set this.success to false
		var is_successful = this.success;

		YAHOO.util.Dom.addClass("yui_clearlist", "displayinline");
		YAHOO.util.Dom.removeClass("yui_clearlist", "hidden");
		if (this.errors == 0)
		{
			this.clear(e);
			this.events.handleresponse_noerrors.fire();
		}
		else
		{
			this.events.handleresponse_errors.fire();
		}

		YAHOO.util.Dom.addClass("yui_progressbar_container", "hidden");
		if (is_successful)
		{
			this.events.handleresponse.fire();
		}
	}
}

vB_YUI_Upload.prototype.ready = function(e)
{
	this.uploader.setAllowMultipleFiles(true);
	if (this.initactive)
	{
		this.active = true;
	}
	this.valid = true;
	this.events.ready.fire();
}

vB_YUI_Upload.prototype.setvars = function(ext, phrases, attachlimit, max_file_size)
{
	// Assign file extensions
	this.phrases = phrases;
	this.extensions = ext;
	this.attachlimit = attachlimit;
	this.max_file_size = max_file_size;
	var extensions = "";

	for (var x in ext)
	{
		extensions += (extensions != "" ? ";" : "") + "*." + x;
	}
	var ff = new Array(
		{
			description : this.phrases["all_files"],
			extensions  : extensions
		}
	);

	if (this.uploader)
	{
		this.uploader.setFileFilters(ff);
	}
}

vB_YUI_Upload.prototype.select = function(e)
{
	if (e.fileList != null)
	{
		if (this.filelist)
		{
			for (var x in this.filelist)
			{
				var progressli = YAHOO.util.Dom.get(this.filelist[x].id);
				if (progressli)
				{
					progressli.parentNode.removeChild(progressli);
				}
			}
		}
		var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", "asset_upload_list");
		var successes = 0;
		this.filelist = {};

		var temparray = new Array();

		for (var x in e.fileList)
		{
			var value = x.match(/\d+$/);
			temparray.push(value);
		}

		temparray.sort(function(a,b){return a-b});
		for (var x = 0; x < temparray.length; x++)
		{
			this.filelist["file" + temparray[x]] = e.fileList["file" + temparray[x]];
		}

		for (var x in this.filelist)
		{
			var skip = "";
			var id = this.filelist[x].id;
			var progressli = YAHOO.util.Dom.get("sampleli");
			var newprogress = progressli.cloneNode(true);
			YAHOO.util.Dom.get("uploadprogress_ul").appendChild(newprogress);
			YAHOO.util.Dom.setAttribute(newprogress, "id", id);
			YAHOO.util.Dom.removeClass(newprogress, "hidden");
			var filename = YAHOO.util.Dom.getElementsByClassName("name", "div", newprogress);
			filename[0].innerHTML = this.filelist[x].name;
			YAHOO.util.Dom.setAttribute(filename[0], "title", this.filelist[x].name);

			var filesize = YAHOO.util.Dom.getElementsByClassName("size", "div", newprogress);
			filesize[0].innerHTML = format_filesize(this.filelist[x].size);
			if (this.max_file_size && this.filelist[x].size > this.max_file_size)
			{
				skip = this.phrases["file_is_too_large"];
			}
			else
			{
				var lastpos = this.filelist[x].name.lastIndexOf(".");
				if (lastpos != -1)
				{
					// Check filelimit!
					var extension = this.filelist[x].name.substr(lastpos + 1).toLowerCase();
					if (!YAHOO.lang.hasOwnProperty(this.extensions, extension))
					{
						skip = this.phrases["invalid_file"];
					}
					else if (this.extensions[extension] != 0 && this.filelist[x].size > this.extensions[extension] && !PHP.in_array(extension, new Array("jpg", "jpe", "jpeg", "gif", "png"), true))
					{
						skip = this.phrases["file_is_too_large"];
					}
					else
					{
						if (this.attachlimit == 0 || (attachments.length + successes) < this.attachlimit)
						{
							successes++;
						}
						else
						{
							skip = this.phrases["maximum_number_of_attachments_reached"];
						}
					}
				}
				else
				{
					skip = this.phrases["invalid_file"];
				}
			}
			if (skip)
			{
				this.uploader.removeFile(id);
				delete(this.filelist[id]);
				this.displayerror(id, skip);
			}
		}

		YAHOO.util.Dom.removeClass("yui_clearlist", "hidden");
		YAHOO.util.Dom.removeClass("yui_uploadfiles", "hidden");
		YAHOO.util.Dom.addClass("yui_clearlist", "displayinline");
		YAHOO.util.Dom.addClass("yui_uploadfiles", "displayinline");
		this.moveflashobj();
		this.events.select.fire();
		this.errors = 0;
	}
	this.updatetotal();
}

vB_YUI_Upload.prototype.clear = function(e)
{
	try
	{
		this.uploader.cancel();
	}
	catch(e)
	{}
	try
	{
		this.uploader.clearFileList();
	}
	catch(e)
	{}

	var uploadli = YAHOO.util.Dom.get("uploadprogress_ul");
	var lis = uploadli.getElementsByTagName("li");
	if (lis.length)
	{
		var length = lis.length;
		for (var x = 1; x < length; x++)
		{
			uploadli.removeChild(lis[1]);
		}
	}

	YAHOO.util.Dom.addClass("yui_clearlist", "hidden");
	YAHOO.util.Dom.addClass("yui_uploadfiles", "hidden");
	YAHOO.util.Dom.addClass("yui_selectfilestext", "displayinline");
	YAHOO.util.Dom.removeClass("yui_clearlist", "displayinline");
	YAHOO.util.Dom.removeClass("yui_uploadfiles", "displayinline");
	YAHOO.util.Dom.removeClass("yui_selectfilestext", "hidden");
	YAHOO.util.Dom.removeClass("upload_controls_close3", "hidden");
	this.moveflashobj();
	this.events.clear.fire();
	this.filelist = null;
	this.updatetotal();
	this.errors = 0;
	this.success = false;
}

function number_format(number, decimals, dec_point, thousands_sep)
{
	// Formats a number with grouped thousands
	//
	// version: 902.1517
	// discuss at: http://phpjs.org/functions/number_format
	// +   original by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
	// +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
	// +     bugfix by: Michael White (http://getsprink.com)
	// +     bugfix by: Benjamin Lupton
	// +     bugfix by: Allan Jensen (http://www.winternet.no)
	// +    revised by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
	// +     bugfix by: Howard Yeend
	// +    revised by: Luke Smith (http://lucassmith.name)
	// +     bugfix by: Diogo Resende
	// +     bugfix by: Rival
	// %        note 1: For 1000.55 result with precision 1 in FF/Opera is 1,000.5, but in IE is 1,000.6
	// *     example 1: number_format(1234.56);
	// *     returns 1: &#039;1,235&#039;
	// *     example 2: number_format(1234.56, 2, &#039;,&#039;, &#039; &#039;);
	// *     returns 2: &#039;1 234,56&#039;
	// *     example 3: number_format(1234.5678, 2, &#039;.&#039;, &#039;&#039;);
	// *     returns 3: &#039;1234.57&#039;

	// *     example 4: number_format(67, 2, &#039;,&#039;, &#039;.&#039;);
	// *     returns 4: &#039;67,00&#039;
	// *     example 5: number_format(1000);
	// *     returns 5: &#039;1,000&#039;
	// *     example 6: number_format(67.311, 2);
	// *     returns 6: &#039;67.31&#039;

	var n = number, prec = decimals;
	n = !isFinite(+n) ? 0 : +n;
	prec = !isFinite(+prec) ? 0 : Math.abs(prec);
	var sep = (typeof thousands_sep == "undefined") ? ',' : thousands_sep;
	var dec = (typeof dec_point == "undefined") ? '.' : dec_point;
	var s = (prec > 0) ? n.toFixed(prec) : Math.round(n).toFixed(prec); //fix for IE parseFloat(0.55).toFixed(0) = 0;
	var abs = Math.abs(n).toFixed(prec);
	var _, i;

	if (abs >= 1000)
	{
		_ = abs.split(/\D/);
		i = _[0].length % 3 || 3;

		_[0] = s.slice(0,i + (n < 0)) +
		_[0].slice(i).replace(/(\d{3})/g, sep+'$1');

		s = _.join(dec);
	}
	else
	{
		s = s.replace('.', dec);
	}

	return s;
}

function format_filesize(number)
{
	if (number == 0)
	{
		return number;
	}
	var decimals = 2;
	var type = "";
	if (number >= 1073741824)
	{
		number = number / 1073741824;
		type = "GB";
	}
	else if (number >= 1048576)
	{
		number = number / 1048576;
		type = "MB";
	}
	else if (number >= 1024)
	{
		number = number / 1024;
		decimals = 1;
		type = "KB";
	}
	else
	{
		number = number / 1024;
		decimals = 2;
		type = "KB";
	}
	return number_format(number, decimals) + " " + type;
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 31986 $
|| ####################################################################
\*======================================================================*/